﻿' TextSplitter - World's Simplest Text Tool
' WinForms VB.NET Example
' Create a new WinForms project and replace Form1.vb with this code

Imports System.Text.RegularExpressions

Public Class Form1

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        Me.Text = "Text Splitter"
    End Sub

    Private Sub btnSplit_Click(sender As Object, e As EventArgs) Handles btnSplit.Click
        Dim input As String = txtInput.Text
        Dim separator As String = txtJoin.Text
        If separator = "\n" Then
            separator = vbCrLf
        End If
        Dim prefix As String = txtPrefix.Text
        Dim suffix As String = txtSuffix.Text

        Dim parts As New List(Of String)

        Try
            If rbChar.Checked Then
                parts = input.Split(New String() {txtChar.Text}, StringSplitOptions.RemoveEmptyEntries).ToList()

            ElseIf rbRegex.Checked Then
                parts = Regex.Split(input, txtRegex.Text).Where(Function(x) x <> "").ToList()

            ElseIf rbWidth.Checked Then
                Dim width As Integer = CInt(numWidth.Value)
                For i = 0 To input.Length - 1 Step width
                    parts.Add(input.Substring(i, Math.Min(width, input.Length - i)))
                Next

            ElseIf rbChunks.Checked Then
                Dim chunks As Integer = CInt(numChunks.Value)
                Dim size As Integer = CInt(Math.Ceiling(input.Length / chunks))
                For i = 0 To input.Length - 1 Step size
                    parts.Add(input.Substring(i, Math.Min(size, input.Length - i)))
                Next
            End If

            Dim wrapped = parts.Select(Function(p) prefix & p & suffix)
            txtOutput.Text = String.Join(separator, wrapped)

        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub
End Class
